// *************************************************************************
// freiesMagazin-Programmierwettbewerb (ai)
// Copyright 2009 Dominik Wagenfuehr <dominik.wagenfuehr@deesaster.org>
// Licence: GPLv3
// *************************************************************************

/**
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SWAPPINGPOS_H
#define SWAPPINGPOS_H

#include "fieldpos.h"

class SwappingPos 
{
public:     // methods
 
    // standard constructor
    SwappingPos(void);

    // constructor
    SwappingPos(const FieldPos& pos1, const FieldPos& pos2);

    // Copy constructor
    SwappingPos(const SwappingPos& positions);
    
    // destructor
    ~SwappingPos(void);
    
    // set position
    void set(const FieldPos& pos1, const FieldPos& pos2);

    // add value for this swapping
    // setting is done during construction
    void addValue(const int value);

    // return first position
    const FieldPos& first(void) const;

    // return second position
    const FieldPos& second(void) const;
    
    // return value for this swapping
    const int getValue(void) const;
    
    // return true if tiles has been swapped horizontal in one row
    const bool isSwapInRow( void ) const;

    // return true if tiles has been swapped vertical in one columns
    const bool isSwapInColumn( void ) const;
    
private:    // members

    // positions
    FieldPos m_firstPos;
    FieldPos m_secondPos;
    
    // value for this position swapping
    int m_value;
};

#endif // SWAPPINGPOS_H
