// *************************************************************************
// freiesMagazin-Programmierwettbewerb (ai)
// Copyright 2009 Dominik Wagenfuehr <dominik.wagenfuehr@deesaster.org>
// Licence: GPLv3
// *************************************************************************

/**
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// System
///////////
#include <iostream>

// Own
//////////////
#include "swappingpos.h"

// standard constructor
SwappingPos::SwappingPos(void)
    : m_value(0)
{
}

// constructor
SwappingPos::SwappingPos(const FieldPos& pos1, const FieldPos& pos2)
    : m_firstPos(pos1), m_secondPos(pos2), m_value(0)
{
}
    
// Copy constructor
SwappingPos::SwappingPos(const SwappingPos& pos)
    : m_firstPos(pos.m_firstPos), m_secondPos(pos.m_secondPos),
      m_value(pos.m_value)
{
}
  
// destructor
SwappingPos::~SwappingPos(void)
{
}

// set position
void SwappingPos::set(const FieldPos& pos1, const FieldPos& pos2)
{
    m_firstPos = pos1;
    m_secondPos = pos2;
    
    // the value is null and will be calculated later
    m_value = 0;
}

// add value for this swapping
void SwappingPos::addValue(const int value)
{
    m_value += value;
}

// return first position
const FieldPos& SwappingPos::first(void) const
{
    return m_firstPos;
}

// return second position
const FieldPos& SwappingPos::second(void) const
{
    return m_secondPos;
}

// return value for this swapping
const int SwappingPos::getValue(void) const
{
    return m_value;
}

// return true if tiles has been swapped horizontal in one row
const bool SwappingPos::isSwapInRow( void ) const
{
   return ( m_firstPos.y() == m_secondPos.y() );
}

// return true if tiles has been swapped vertical in one columns
const bool SwappingPos::isSwapInColumn( void ) const
{
   return ( m_firstPos.x() == m_secondPos.x() );
}
