// *************************************************************************
// freiesMagazin-Programmierwettbewerb (ai)
// Copyright 2009 Dominik Wagenfuehr <dominik.wagenfuehr@deesaster.org>
// Licence: GPLv3
// *************************************************************************

/**
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// System
///////////
#include <stdlib.h>
#include <string>
#include <iostream>

// Eigene
///////////
#include "game.h"

int main (void)
{
    // create game
    Game game;

    // set KI strength    
    game.setStrength( Game::GAME_STRENGTH_PHASE2 );
    
    // read data from disk
    if ( !game.readData( "gamefield.dat", "player.dat", "opponent.dat" ) )
    {
        exit(1);
    }   
    
    if ( !game.calculateAndSaveBestPosition( "result.dat" ) )
    {
        exit(1);
    }  
    
    return 0;
}
