// *************************************************************************
// freiesMagazin-Programmierwettbewerb (ai)
// Copyright 2009 Dominik Wagenfuehr <dominik.wagenfuehr@deesaster.org>
// Licence: GPLv3
// *************************************************************************

/**
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef GAMEFIELD_H
#define GAMEFIELD_H

// System
//////////////
#include <string>

// Own
//////////////
#include "tile.h"
#include "player.h"
#include "fieldpos.h"
#include "fieldposarray.h"
#include "swappingposarray.h"

class GameField 
{
private:    // enumerators

    // game specifications (may change later)
    enum GameSpec
    {
        FIELD_WIDTH = 10,
        FIELD_HEIGHT = 10
    };

public:     // methods
 
    // standard constructor
    // init game field
    GameField(void);

    // Copy constructor
    GameField(const GameField& field);
    
    // destructor
    ~GameField(void);

    // opens file and reads the first 100 relevant characters
    // newline, cr, spaces and tabs will be ignored
    // return true if everything is ok
    const bool read( const std::string& filename );

    // search all tiles on game field that could be swapped
    // return true if resulting array is not empty
    const bool findSwapPositions( SwappingPosArray& positions ) const;

    // tries to swap two tiles
    // return true if possible
    const bool swapTiles( const SwappingPos& pos );

    // search for equal tiles
    // return true if something has been found
    const bool findSameTiles( ScoredTileArray* array = NULL ) const;    

    // search for equal tiles at special position
    // return true if something has been found
    const bool findSameTiles( const SwappingPos& pos,
                              ScoredTileArray* array = NULL ) const;    

    // let all existing tiles fall to the ground
    // return false if there are no new tiles (random tiles needed)
    void fallTilesToGround(void);    
    
    // removes tiles on field
    void removeTiles(const ScoredTileArray& tArray);

    // prints the game field on screen
    void print(void) const;

    // calculate value for this field for one swapping position
    // return true if everything is ok
    const bool findSameTilesCascading( ScoredTileArray& array,
                                       const bool cascading = false );

    // calculate value for this field for one swapping position
    // start with this swapping position befor cascading
    // return true if everything is ok
    const bool findSameTilesCascading( const SwappingPos& pos,
                                       ScoredTileArray& array,
                                       const bool cascading = false );

    // remove from array and search new same tiles
    // return true if new tiles has been found
    const bool removeAndFindSameTiles( ScoredTileArray& array );

private:    // methods

    // copy game field
    void set(const GameField& field);
    
    // swap tiles at positions and check if there are same tiles connected
    // return true if position could be found
    const bool checkSwapPosition(SwappingPos& pos) const;

    // return const reference for tile    
    const Tile& getTile(const FieldPos& pos) const;

    // return reference for tile    
    Tile& getTile(const FieldPos& pos);

    // search for equal tiles in rows
    // return true if something has been found
    const bool findSameTilesInRows( ScoredTileArray* tArray ) const;    

    // search for equal tiles in columns
    // return true if something has been found
    const bool findSameTilesInColumns( ScoredTileArray* tArray ) const;   

    // search for equal tiles in single row
    // return true if something has been found
    const bool findSameTilesInRow( const unsigned int pos, ScoredTileArray* tArray ) const;    

    // search for equal tiles in single row
    // return true if something has been found
    const bool findSameTilesInColumn( const unsigned int pos, ScoredTileArray* tArray ) const;   

    // remove all stored tiles
    void removeTiles(const ScoredTile& tile);
    
private:    // members
    
    // we only need a 10x10 game field
    Tile m_field[FIELD_WIDTH][FIELD_HEIGHT];
    
    // dummy tile if access is out of boundary
    Tile m_dummyTile;

};

#endif // GAMEFIELD_H
